﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System;
using System.Collections.Generic;
using System.Xml;
using System.IO;

namespace GE.Tools
{
    class Profiler
    {
        class Measure
        {
            public TimeSpan Total;
            public DateTime Start;
            public int Ticks;

            public Measure()
            {
                Total = TimeSpan.Zero;
                Ticks = 0;
            }
        }

        private static Profiler m_instance = new Profiler();
        private Dictionary<string, Measure> m_measures;

        public static Profiler Instance
        {
            get { return m_instance; }
        }

        private Profiler()
        {
            m_measures = new Dictionary<string, Measure>();
        }

        public void start(string name)
        {
            if (!m_measures.ContainsKey(name))
                m_measures.Add(name, new Measure());
            m_measures[name].Start = DateTime.Now;
        }

        public void stop(string name)
        {
            if (m_measures.ContainsKey(name))
            {
                Measure m = m_measures[name];
                m.Total += DateTime.Now.Subtract(m.Start);
                m.Ticks++;
            }
        }

        public void output(string filename)
        {
#if XBOX360
            return;
#endif
            XmlTextWriter writer = new XmlTextWriter(filename, System.Text.Encoding.UTF8);
            writer.Formatting = Formatting.Indented;
            writer.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
            writer.WriteStartElement("profiling");
            writer.Close();

            XmlDocument doc = new XmlDocument();
            doc.Load(filename);
            XmlElement root = doc.DocumentElement;

            foreach (string s in m_measures.Keys)
            {
                Measure measure = m_measures[s];
                XmlElement element = doc.CreateElement("measure");
                element.SetAttribute("name", s);
                element.SetAttribute("ticks", measure.Ticks.ToString());
                element.SetAttribute("totalDuration", measure.Total.TotalMilliseconds.ToString());
                element.SetAttribute("tickDuration",
                    ((double)measure.Total.TotalMilliseconds / measure.Ticks).ToString());
                root.AppendChild(element);
            }

            doc.Save(filename);
        }
    }
}
